<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('solution_sections', function(Blueprint $table) {
			$table->foreign('solution_id')->references('id')->on('solutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('solution_faqs', function(Blueprint $table) {
			$table->foreign('solution_id')->references('id')->on('solutions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('site_news', function(Blueprint $table) {
			$table->foreign('year_id')->references('id')->on('new_years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->foreign('job_type_id')->references('id')->on('job_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->foreign('experience_id')->references('id')->on('experience_years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_titles', function(Blueprint $table) {
			$table->foreign('job_type_id')->references('id')->on('job_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('solution_sections', function(Blueprint $table) {
			$table->dropForeign('solution_sections_solution_id_foreign');
		});
		Schema::table('solution_faqs', function(Blueprint $table) {
			$table->dropForeign('solution_faqs_solution_id_foreign');
		});
		Schema::table('site_news', function(Blueprint $table) {
			$table->dropForeign('site_news_year_id_foreign');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->dropForeign('job_requests_job_type_id_foreign');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->dropForeign('job_requests_job_title_id_foreign');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->dropForeign('job_requests_region_id_foreign');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->dropForeign('job_requests_city_id_foreign');
		});
		Schema::table('job_requests', function(Blueprint $table) {
			$table->dropForeign('job_requests_experience_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_region_id_foreign');
		});
		Schema::table('job_titles', function(Blueprint $table) {
			$table->dropForeign('job_titles_job_type_id_foreign');
		});
	}
}