<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationsTable extends Migration {

	public function up()
	{
		Schema::create('donations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('blood', 255);
			$table->string('hospital_name', 255);
			$table->integer('city_id');
			$table->string('phone', 255);
			$table->string('name', 255);
			$table->string('age', 50);
			$table->string('bags_number', 255);
			$table->text('hospital_address');
			$table->text('notes');
			$table->decimal('lat', 10,8);
			$table->integer('client_id')->unsigned();
			$table->decimal('lng', 10,8);
		});
	}

	public function down()
	{
		Schema::drop('donations');
	}
}