<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('equipe_a')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('equipe_b')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('saisons', function(Blueprint $table) {
			$table->foreign('championnat_id')->references('id')->on('championnats')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_equipe_a_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_equipe_b_foreign');
		});
		Schema::table('saisons', function(Blueprint $table) {
			$table->dropForeign('saisons_championnat_id_foreign');
		});
	}
}