<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('lat', 25);
			$table->string('long', 25);
			$table->string('name', 100);
			$table->bigInteger('city_id')->unsigned();
			$table->text('full_address');
			$table->bigInteger('customer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}