<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArchivedService extends Model 
{

    protected $table = 'archived_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'category_id');

    public function category()
    {
        return $this->belongsTo('ArchivedCategory', 'category_id');
    }

    public function branches()
    {
        return $this->belongsToMany('Branch', 'archived_service_branch', 'service_id', 'brach_id');
    }

}