<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceLocation extends Model 
{

    protected $table = 'service_location';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('location_id', 'service_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function location()
    {
        return $this->belongsTo('Location', 'location_id');
    }

}