<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class State extends Model 
{

    protected $table = 'state';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('state_name', 'state_id', 'country_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_d');
    }

}