<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorTable extends Migration {

	public function up()
	{
		Schema::create('doctor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->date('birthdate')->nullable();
			$table->integer('nationality_id')->nullable();
			$table->integer('specialty_id')->nullable();
			$table->integer('degree_id')->nullable();
			$table->text('certifications')->nullable();
			$table->text('experiences')->nullable();
			$table->text('positions')->nullable();
			$table->string('years')->nullable();
			$table->text('certifications_ar')->nullable();
			$table->text('experiences_ar')->nullable();
			$table->text('positions_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doctor');
	}
}