<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArchivedCategory extends Model 
{

    protected $table = 'archived_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar');

    public function branches()
    {
        return $this->belongsToMany('Branch', 'archived_category_branch', 'category_id', 'branch_id');
    }

}