<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArchivedCategoryBranch extends Model 
{

    protected $table = 'archived_category_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'category_id');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function category()
    {
        return $this->belongsTo('ArchivedCategory', 'category_id');
    }

}