<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->double('price')->nullable();
			$table->integer('category_id')->nullable();
			$table->boolean('booking')->nullable();
			$table->boolean('require_address')->nullable()->default(0);
			$table->boolean('require_reason')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}