<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tramite', function(Blueprint $table) {
			$table->foreign('dependencia_id')->references('id')->on('dependencia')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cronograma', function(Blueprint $table) {
			$table->foreign('tramite_id')->references('id')->on('tramite')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contribuyente', function(Blueprint $table) {
			$table->foreign('documento_tipo_id')->references('id')->on('documento_tipo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('turno', function(Blueprint $table) {
			$table->foreign('cronograma_id')->references('id')->on('cronograma')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('turno', function(Blueprint $table) {
			$table->foreign('contribuyente_id')->references('id')->on('contribuyente')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('feriado', function(Blueprint $table) {
			$table->foreign('dependencia_id')->references('id')->on('dependencia')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dependencia_usuario', function(Blueprint $table) {
			$table->foreign('dependencia_id')->references('id')->on('dependencia')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tramite', function(Blueprint $table) {
			$table->dropForeign('tramite_dependencia_id_foreign');
		});
		Schema::table('cronograma', function(Blueprint $table) {
			$table->dropForeign('cronograma_tramite_id_foreign');
		});
		Schema::table('contribuyente', function(Blueprint $table) {
			$table->dropForeign('contribuyente_documento_tipo_id_foreign');
		});
		Schema::table('turno', function(Blueprint $table) {
			$table->dropForeign('turno_cronograma_id_foreign');
		});
		Schema::table('turno', function(Blueprint $table) {
			$table->dropForeign('turno_contribuyente_id_foreign');
		});
		Schema::table('feriado', function(Blueprint $table) {
			$table->dropForeign('feriado_dependencia_id_foreign');
		});
		Schema::table('dependencia_usuario', function(Blueprint $table) {
			$table->dropForeign('dependencia_usuario_dependencia_id_foreign');
		});
	}
}