<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tramite extends Eloquent {

	protected $table = 'tramite';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function dependencia()
	{
		return $this->belongsTo('Dependencia', 'dependencia_id');
	}

	public function cronogramas()
	{
		return $this->hasMany('Cronograma', 'tramite_id');
	}

}