<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticulosFacturasTable extends Migration {

	public function up()
	{
		Schema::create('articulos_facturas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('articulo_id')->unsigned()->nullable();
			$table->integer('factura_id')->unsigned();
			$table->float('base_imponible');
			$table->float('descuento')->default('0');
			$table->text('descripcion');
			$table->smallInteger('cantidad');
			$table->integer('tipo_iva_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('articulos_facturas');
	}
}