<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('familia_id')->references('id')->on('familias_productos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('tipo_iva_id')->references('id')->on('tipos_iva')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('fabricante_id')->references('id')->on('fabricantes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('almacen_preferido_id')->references('id')->on('almacenes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('proveedor_preferido_id')->references('id')->on('proveedores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->foreign('articulo_id')->references('id')->on('articulos')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->foreign('almacen_id')->references('id')->on('almacenes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->foreign('proveedor_id')->references('id')->on('proveedores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->foreign('padre_id')->references('id')->on('articulos_reales')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('estados', function(Blueprint $table) {
			$table->foreign('articulo_real_id')->references('id')->on('articulos_reales')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('facturas', function(Blueprint $table) {
			$table->foreign('cliente_id')->references('id')->on('clientes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->foreign('tarifa_id')->references('id')->on('tarifas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->foreign('articulo_id')->references('id')->on('articulos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->foreign('factura_id')->references('id')->on('facturas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->foreign('tipo_iva_id')->references('id')->on('tipos_iva')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tarifas_articulos', function(Blueprint $table) {
			$table->foreign('articulo_id')->references('id')->on('articulos')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tarifas_articulos', function(Blueprint $table) {
			$table->foreign('tarifa_id')->references('id')->on('tarifas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_familia_id_foreign');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_tipo_iva_id_foreign');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_fabricante_id_foreign');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_almacen_preferido_id_foreign');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_proveedor_preferido_id_foreign');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->dropForeign('articulos_reales_articulo_id_foreign');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->dropForeign('articulos_reales_almacen_id_foreign');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->dropForeign('articulos_reales_proveedor_id_foreign');
		});
		Schema::table('articulos_reales', function(Blueprint $table) {
			$table->dropForeign('articulos_reales_padre_id_foreign');
		});
		Schema::table('estados', function(Blueprint $table) {
			$table->dropForeign('estados_articulo_real_id_foreign');
		});
		Schema::table('facturas', function(Blueprint $table) {
			$table->dropForeign('facturas_cliente_id_foreign');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->dropForeign('clientes_tarifa_id_foreign');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->dropForeign('articulos_facturas_articulo_id_foreign');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->dropForeign('articulos_facturas_factura_id_foreign');
		});
		Schema::table('articulos_facturas', function(Blueprint $table) {
			$table->dropForeign('articulos_facturas_tipo_iva_id_foreign');
		});
		Schema::table('tarifas_articulos', function(Blueprint $table) {
			$table->dropForeign('tarifas_articulos_articulo_id_foreign');
		});
		Schema::table('tarifas_articulos', function(Blueprint $table) {
			$table->dropForeign('tarifas_articulos_tarifa_id_foreign');
		});
	}
}