<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApprovalWorkflowsTable extends Migration {

	public function up()
	{
		Schema::create('approval_workflows', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('comments')->nullable();
			$table->enum('approval_status', array('approved', 'rejected', 'pending'));
			$table->integer('approver_id')->unsigned();
			$table->integer('panel_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('approval_workflows');
	}
}