<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ApprovalWorkflow extends Eloquent {

	protected $table = 'approval_workflows';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('comments', 'approval_status', 'approver_id', 'panel_id');

	public function panel()
	{
		return $this->belongsTo('App\Models\Panel');
	}

	public function approver()
	{
		return $this->belongsTo('App\Models\User');
	}

}