<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bend extends Eloquent {

	protected $table = 'bends';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('k_factor', 'bend_type', 'bend_radius', 'bend_angle', 'panel_id');

	public function panel()
	{
		return $this->belongsTo('App\Models\Panel');
	}

}