<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class File extends Eloquent {

	protected $table = 'files';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'status', 'file_url', 'file_name', 'file_type');

	public function project()
	{
		return $this->belongsTo('App\Models\Project');
	}

}