<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email', 'password', 'first_name', 'last_name');

	public function projects()
	{
		return $this->hasMany('App\Models\Project');
	}

	public function approvals()
	{
		return $this->hasMany('App\Models\ApprovalWorkflow');
	}

	public function logs()
	{
		return $this->hasMany('App\Models\Log');
	}

}