<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function postHistory()
	{
		return $this->hasMany('\App\Model\PostHistory');
	}

	public function socialMediaType()
	{
		return $this->hasOne('\App\Model\SocialMediaTypes');
	}

	public function influencer()
	{
		return $this->belongsTo('\App\Model\Influencer');
	}

}