<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('advertiser_id')->references('id')->on('advertisers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('social_media_type_id')->references('id')->on('social_media_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advertisers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('social_media', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('social_media', function(Blueprint $table) {
			$table->foreign('social_media_type_id')->references('id')->on('social_media_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_history', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('escrow_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('escrow_history')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_advertiser_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_influencer_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_campaign_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_social_media_type_id_foreign');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->dropForeign('influencers_user_id_foreign');
		});
		Schema::table('advertisers', function(Blueprint $table) {
			$table->dropForeign('advertisers_user_id_foreign');
		});
		Schema::table('social_media', function(Blueprint $table) {
			$table->dropForeign('social_media_influencer_id_foreign');
		});
		Schema::table('social_media', function(Blueprint $table) {
			$table->dropForeign('social_media_social_media_type_id_foreign');
		});
		Schema::table('post_history', function(Blueprint $table) {
			$table->dropForeign('post_history_post_id_foreign');
		});
		Schema::table('escrow_history', function(Blueprint $table) {
			$table->dropForeign('escrow_history_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_post_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_user_id_foreign');
		});
	}
}