<?php

namespace App;

class OrderProduct extends Eloquent {

	protected $table = 'order_product';
	public $timestamps = true;
	protected $fillable = array('id', 'qty', 'price', 'order_id', 'product_id', 'material_pro_attr_id');

	public function getOrder()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

	public function getProduct()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function getColor()
	{
		return $this->belongsTo('ProductAttribute', 'color_id');
	}

	public function getSize()
	{
		return $this->belongsTo('OrderProduct', 'size_id');
	}

}