<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BudgetPlan extends Eloquent {

	protected $table = 'budget_plan';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('father_id');

	public function costs_center()
	{
		return $this->hasOne('App\CostsCenter');
	}

	public function year()
	{
		return $this->hasOne('App\Year');
	}

	public function rubro_type()
	{
		return $this->hasOne('App\RubroType');
	}

}