<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('street');
			$table->string('postal_code');
			$table->string('city');
			$table->integer('region_id')->unsigned()->nullable();
			$table->integer('country_id')->unsigned();
			$table->string('email');
			$table->string('phone_number');
			$table->string('photo_path')->nullable();
			$table->date('birthdate');
			$table->integer('current_job_sector_id')->unsigned()->nullable();
			$table->integer('current_job_category_id')->unsigned()->nullable();
			$table->string('current_job_title')->nullable();
			$table->smallInteger('employed_since')->unsigned()->nullable();
			$table->float('gross_salary', 7,2)->nullable()->default('0');
			$table->string('driving_license')->nullable();
			$table->string('cv_path')->nullable();
			$table->string('motivation_letter_path')->nullable();
			$table->text('relevant_info')->nullable();
			$table->string('linkedin')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}