<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Car extends Model 
{

    protected $table = 'cars';
    public $timestamps = true;
    protected $fillable = array('admin_id', 'city_id', 'user_id', 'title', 'description', 'latitude', 'type', 'price', 'longitude', 'location', 'whatsapp_phone', 'status', 'stock');

    public function showroom()
    {
        return $this->belongsTo('Showroom');
    }

    public function features()
    {
        return $this->belongsToMany('Feature');
    }

    public function images()
    {
        return $this->hasMany('CarsImage');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function currencies()
    {
        return $this->hasMany('Currency');
    }

}