<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('inventory_id')->references('id')->on('inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->dropForeign('inventory_user_id_foreign');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->dropForeign('inventory_type_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_order_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_inventory_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_address_id_foreign');
		});
		Schema::table('order_lines', function(Blueprint $table) {
			$table->dropForeign('order_lines_location_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoice_lines', function(Blueprint $table) {
			$table->dropForeign('invoice_lines_invoice_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
	}
}