<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->enum('soort', array(''admin'', ''klant''));
			$table->string('aanhef', 255)->nullable();
			$table->string('initialen', 31)->nullable();
			$table->string('voornaam', 255);
			$table->string('achternaam', 255);
			$table->string('remember_token', 100)->nullable();
			$table->string('register_token', 100)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}