<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DoorKnocker extends Model 
{

    protected $table = 'Doorknocker';
    public $timestamps = true;

    public function User()
    {
        return $this->belongsTo('App\Users', 'id');
    }

    public function Bookings()
    {
        return $this->belongsToMany('Bookings', 'doorKnockerId');
    }

    public function waterCustomers()
    {
        return $this->hasManyThrough('App\WaterCustomer', 'App\bookings', 'waterCustId', 'id', 'doorKnockerId');
    }

}