<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->text('questionText');
			$table->enum('questionCategory', array('generic', 'kitchen', 'bathroom', 'bathroom2', 'bathroom3', 'bathroom4', 'bathroom5', 'utilityroom', 'outdoors', 'other'));
			$table->enum('isDependent', array('Yes', 'No'));
			$table->enum('weaStatus', array('Active', 'Inactive'));
			$table->bigInteger('weqDisplayOrder')->nullable();
			$table->integer('questionAreaId')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}