<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWaterCustomerTable extends Migration {

	public function up()
	{
		Schema::create('waterCustomer', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('title', array('MR', 'MRS', 'MS', 'MISS', 'DR', 'LORD', 'LADY'));
			$table->string('firstName', 45);
			$table->string('lastName', 50);
			$table->string('email', 100);
			$table->string('mobileNumber', 20);
			$table->string('mainNumber', 20);
			$table->string('referanceCompanyId', 50)->nullable();
			$table->string('numberName', 50)->nullable()->default('0');
			$table->string('addressOne', 250);
			$table->string('addressTwo', 250)->nullable();
			$table->string('town', 50)->nullable();
			$table->string('postcode', 10);
			$table->boolean('Archived')->default(false);
			$table->enum('insertOrigin', array('csv', 'admin_panel', 'doorknocker_application'));
			$table->smallInteger('waterProviderId')->unsigned();
			$table->string('currentReading', 10);
			$table->date('currentReadDate')->nullable();
			$table->string('previousRead', 20)->nullable();
			$table->date('previousReadDate');
			$table->boolean('over16AndBillPayer');
			$table->enum('marketing', array('DoorKnocker', 'Letter', 'Refered', 'Email'))->nullable();
			$table->string('security_password', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('waterCustomer');
	}
}