<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('category_to_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('category_to_categories', function(Blueprint $table) {
			$table->foreign('child_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('books_categories', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('books_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('category_to_categories', function(Blueprint $table) {
			$table->dropForeign('category_to_categories_parent_id_foreign');
		});
		Schema::table('category_to_categories', function(Blueprint $table) {
			$table->dropForeign('category_to_categories_child_id_foreign');
		});
		Schema::table('books_categories', function(Blueprint $table) {
			$table->dropForeign('books_categories_book_id_foreign');
		});
		Schema::table('books_categories', function(Blueprint $table) {
			$table->dropForeign('books_categories_category_id_foreign');
		});
	}
}