<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('Teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('mobile', 20);
			$table->bigInteger('specialization_id')->unsigned();
			$table->bigInteger('gender_id')->unsigned();
			$table->string('personal_id');
			$table->date('joining_date');
			$table->string('address');
			$table->integer('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Teachers');
	}
}