<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('provedor_servicios', function(Blueprint $table) {
			$table->foreign('id_provedor')->references('id')->on('provedors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('provedor_servicios', function(Blueprint $table) {
			$table->foreign('id_servicios')->references('id')->on('servicios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alicuotadetalle', function(Blueprint $table) {
			$table->foreign('id_alicuota')->references('id')->on('alicuotas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alicuotadetalle', function(Blueprint $table) {
			$table->foreign('id_provedor_servicios')->references('id')->on('provedor_servicios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propietario_alicuotadetalle', function(Blueprint $table) {
			$table->foreign('id_alicuotadetalle')->references('id')->on('alicuotadetalle')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propietario_alicuotadetalle', function(Blueprint $table) {
			$table->foreign('id_propietario')->references('id')->on('propietarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consiliacion', function(Blueprint $table) {
			$table->foreign('id_pago')->references('id')->on('pagos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consiliacion', function(Blueprint $table) {
			$table->foreign('id_propietarioalicuotadetalle')->references('id')->on('propietario_alicuotadetalle')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('provedor_servicios', function(Blueprint $table) {
			$table->dropForeign('provedor_servicios_id_provedor_foreign');
		});
		Schema::table('provedor_servicios', function(Blueprint $table) {
			$table->dropForeign('provedor_servicios_id_servicios_foreign');
		});
		Schema::table('alicuotadetalle', function(Blueprint $table) {
			$table->dropForeign('alicuotadetalle_id_alicuota_foreign');
		});
		Schema::table('alicuotadetalle', function(Blueprint $table) {
			$table->dropForeign('alicuotadetalle_id_provedor_servicios_foreign');
		});
		Schema::table('propietario_alicuotadetalle', function(Blueprint $table) {
			$table->dropForeign('propietario_alicuotadetalle_id_alicuotadetalle_foreign');
		});
		Schema::table('propietario_alicuotadetalle', function(Blueprint $table) {
			$table->dropForeign('propietario_alicuotadetalle_id_propietario_foreign');
		});
		Schema::table('consiliacion', function(Blueprint $table) {
			$table->dropForeign('consiliacion_id_pago_foreign');
		});
		Schema::table('consiliacion', function(Blueprint $table) {
			$table->dropForeign('consiliacion_id_propietarioalicuotadetalle_foreign');
		});
	}
}