<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('outlet_bay', function(Blueprint $table) {
			$table->foreign('outlet_id')->references('id')->on('outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outlet_bay', function(Blueprint $table) {
			$table->foreign('bay_id')->references('id')->on('outlet_bay')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('outlet_bay', function(Blueprint $table) {
			$table->dropForeign('outlet_bay_outlet_id_foreign');
		});
		Schema::table('outlet_bay', function(Blueprint $table) {
			$table->dropForeign('outlet_bay_bay_id_foreign');
		});
	}
}