<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateManagerTable extends Migration {

	public function up()
	{
		Schema::create('estate_manager', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->string('activation_code');
			$table->integer('extra_messages');
			$table->date('sub_date');
			$table->enum('sub_status', array('active', 'inactive'));
			$table->date('reactivate_date')->nullable();
			$table->date('inreactivate_date');
			$table->date('start_package_date');
			$table->date('end_package_date');
			$table->string('account_owner_name')->nullable();
			$table->string('iban')->nullable();
			$table->boolean('accept_terms_conditions')->nullable();
			$table->integer('bank_id')->unsigned();
			$table->integer('subtype_id')->unsigned();
			$table->integer('marketer_id')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->timestamps();
			$table->enum('user_type', array('estate_manager'));
		});
	}

	public function down()
	{
		Schema::drop('estate_manager');
	}
}