<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProvidersTable extends Migration {

	public function up()
	{
		Schema::create('service_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->double('service_ratio');
			$table->integer('service_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->boolean('default_provider');
			$table->enum('user_type', array('service_provider'));
		});
	}

	public function down()
	{
		Schema::drop('service_providers');
	}
}