<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFreelancersTable extends Migration {

	public function up()
	{
		Schema::create('freelancers', function(Blueprint $table) {
			$table->integer('freelancer_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->integer('phone')->unsigned()->nullable();
			$table->string('image', 20)->nullable();
			$table->string('freelancer_curriculum_vitae', 20)->nullable();
			$table->boolean('premium');
			$table->integer('coins')->unsigned()->nullable();
			$table->string('address')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('freelancers');
	}
}