<?php

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;
	protected $fillable = array('title', 'description', 'duration');

	public function freelancers()
	{
		return $this->belongsToMany('Freelancer', 'FreelancerProject');
	}

	public function enterprise()
	{
		return $this->belongsTo('Enterprise');
	}

	public function challenges()
	{
		return $this->hasMany('Challenge');
	}

	public function skills()
	{
		return $this->belongsToMany('Skill', 'ProjectSkill');
	}

}