<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationSettingsTable extends Migration {

	public function up()
	{
		Schema::create('notification_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('frequency', 191)->nullable();
			$table->string('tone', 191)->nullable();
			$table->integer('period_before_day')->nullable();
			$table->string('period_hour', 191)->nullable();
			$table->integer('pms_before_day')->nullable()->default('191');
			$table->string('pms_hour', 191)->nullable();
			$table->integer('ovulation_before_day')->nullable();
			$table->string('ovulation_hour', 191)->nullable();
			$table->string('remember_log_hour')->nullable();
			$table->integer('remember_log_repeat_day')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notification_settings');
	}
}