<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 191)->nullable();
			$table->timestamp('birth_date')->nullable();
			$table->string('profile_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}