<?php

namespace EmployeeStatus;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeStatus extends Model 
{

    protected $table = 'employee_status';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employeeStatusBelongsToEmployee()
    {
        return $this->belongsTo('Employees', 'employee_id');
    }

}