<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('task_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('mission_type_id')->unsigned();
			$table->bigInteger('task_type_id')->unsigned();
			$table->integer('order');
			$table->bigInteger('parent_id')->unsigned();
			$table->boolean('is_required');
			$table->float('price');
			$table->text('description');
			$table->string('count_handler')->nullable();
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('task_templates');
	}
}