<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->integer('rate');
			$table->integer('status')->nullable()->default('0');
			$table->integer('phase')->default('4');
			$table->string('type', 20)->nullable();
			$table->integer('total');
			$table->integer('count');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}