<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bill extends Model 
{

    protected $table = 'bill';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('vendor_id', 'issue_date', 'due_date', 'supply_date', 'notes', 'country_id', 'mall_id');

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}