<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vendor extends Eloquent {

	protected $table = 'vendor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('mall_id', 'name_en', 'name_ar', 'phone', 'email', 'company_name_en', 'company_name_ar', 'country_id', 'city_id', 'address_en', 'address_ar', 'balance', 'tax_number', 'status');

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}