<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FixedAssets extends Eloquent {

	protected $table = 'fixed_assets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'date', 'price', 'description_en', 'description_ar', 'category_id', 'country_id', 'mall_id');

	public function category()
	{
		return $this->belongsTo('AssetCategory', 'category_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

}