<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Partner extends Eloquent {

	protected $table = 'partner';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'phone', 'percent', 'total', 'country_id', 'mall_id');

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}