<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanningTable extends Migration {

	public function up()
	{
		Schema::create('planning', function(Blueprint $table) {
			$table->increments('planning_id', true);
			$table->timestamps();
			$table->datetime('beginDateTime');
			$table->datetime('endDateTime');
			$table->string('name', 255);
			$table->string('description', 255);
			$table->integer('enterpriseheadquarter_id')->unsigned();
			$table->boolean('isRoster')->default(true);
			$table->boolean('status')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('planning');
	}
}