<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('user_id');
			$table->timestamps();
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('username', 255);
			$table->string('password', 255);
			$table->string('telephone', 255);
			$table->string('email', 255);
			$table->integer('employee_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}